% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{BL.acc}
\alias{BL.acc}
\title{Accumulation of a precipitation stepfunction}
\usage{
BL.acc(sfn, t.acc = 240, acc.val = 1, offset = 0)
}
\arguments{
\item{sfn}{stepfunction of precipitation}

\item{t.acc}{\code{value} specifiying the length of accumulated time series [h]}

\item{acc.val}{\code{value} specifying the accumulation level [h]}

\item{offset}{\code{value} specifying the offset of the accumulated time series [h]}
}
\value{
p.acc \code{data.frame}
}
\description{
\code{BL.acc} accumulates the BLRPM stepfunction for a given accumulation time \code{t.acc}
at a given accumulation level \code{acc.val}. An \code{offse} can be defined. The unit is typically hours.
}
\examples{
lambda <- 4/240
gamma <- 1/10
beta <- 0.3
eta <- 2
mux <- 4
t.sim <- 240
t.acc <- t.sim
acc.val <- 1
offset <- 0

simulation <- BL.sim(lambda,gamma,beta,eta,mux,t.sim)
sfn <- BL.stepfun(simulation$cells)
ts <- BL.acc(sfn,t.acc,acc.val,offset)
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

