% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_blsm_obj}
\alias{example_blsm_obj}
\title{Example BLSM object}
\format{BLSM object (\code{blsm_obj}), i.e. a list containing:
\itemize{
\item \code{Alpha }{\eqn{\alpha} values from the sampled iterations}
\item \code{Likelihood }{Log-likelihood values from the sampled iterations}
\item \code{Iterations }{Latent space coordinates from the sampled iterations. Latent positions are stored in a
3D array whose dimensions are given by (1: number of nodes, 2: space dimensionality, 3: number of iterations).
In the non-Procrustean framework the latent distances are given instead of the positions: another 3D array is returned, whose dimensions
are given by (1: number of nodes, 2: number of nodes, 3: number of iterations). The command needed in order to get the average values over the iterations for
either the positions or the distances is \code{rowMeans(blsm_obj$Iterations, dims=2)} (see example below).}
\item \code{StartingPositions }{Latent space coordinates right after the initialization step. In the non-Procrustean framework starting distances are given instead.}
\item \code{Matrix }{Original matrices of the network (adjacency and BLSM weights)}
\item \code{Parameters }{List of parameters specified during the call to \link[BLSM]{estimate_latent_positions}}
}}
\usage{
example_blsm_obj
}
\description{
BLSM object obtained by applying the Procrustean version of the latent space model to the unweighted network 
whose adjacency matrix is \link[BLSM]{example_adjacency_matrix}. Further details concerning the 
simulation are contained in the BLSM object itself.
}
\keyword{datasets}
