% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_jolts.R
\name{get_jolts}
\alias{get_jolts}
\title{Download Job Openings and Labor Turnover Survey (JOLTS) Data}
\usage{
get_jolts(
  monthly_only = TRUE,
  remove_regions = TRUE,
  remove_national = TRUE,
  suppress_warnings = TRUE,
  return_diagnostics = FALSE
)
}
\arguments{
\item{monthly_only}{Logical. If TRUE (default), excludes annual data (period M13)
and includes only monthly observations.}

\item{remove_regions}{Logical. If TRUE (default), excludes regional aggregates
(Midwest, Northeast, South, West) identified by state codes MW, NE, SO, WE.}

\item{remove_national}{Logical. If TRUE (default), excludes national-level data
(state code 00). Set to FALSE to include national data with industry and
size class breakdowns.}

\item{suppress_warnings}{Logical. If TRUE (default), suppress individual download warnings and diagnostic messages
for cleaner output during batch processing. If FALSE, returns the data and prints warnings and messages to the console.}

\item{return_diagnostics}{Logical. If TRUE, returns a bls_data_collection object
with full diagnostics. If FALSE (default), returns just the data table.}
}
\value{
By default, returns a data.table with JOLTS data. If return_diagnostics = TRUE,
  returns a bls_data_collection object containing JOLTS data with the following key columns:
  \describe{
    \item{series_id}{BLS series identifier}
    \item{year}{Year of observation}
    \item{period}{Time period (M01-M12 for months)}
    \item{value}{JOLTS statistic value (transformed based on data type)}
    \item{date}{Date of observation}
    \item{state_text}{State name}
    \item{dataelement_text}{Type of JOLTS measure (job openings, hires, separations, etc.)}
    \item{area_text}{Geographic area description}
    \item{sizeclass_text}{Establishment size class}
    \item{industry_text}{Industry classification}
    \item{ratelevel_code}{Whether the value is a "Level" (count) or "Rate" (percentage)}
    \item{periodname}{Month name}
  }
}
\description{
This function downloads Job Openings and Labor Turnover data from the U.S. Bureau
of Labor Statistics. JOLTS data provides insights into job market dynamics including
job openings, hires, separations, quits, and layoffs. Data is available at national,
regional, and state levels with various industry and size class breakdowns.
}
\details{
The function performs several data transformations:
  \itemize{
    \item Converts rate values to proportions (divides by 100) except for Unemployed to Job Opening ratio.
    \item Converts level values to actual counts (multiplies by 1000)
    \item Creates a proper date column from year and period
    \item Adds readable month names
  }
}
\examples{
\donttest{
# Download state-level JOLTS data (default - returns data directly)
jolts_data <- get_jolts()

# Include national data with industry breakdowns
jolts_national <- get_jolts(remove_national = FALSE)

# Get full diagnostic object if needed
jolts_with_diagnostics <- get_jolts(return_diagnostics = TRUE)
print_bls_warnings(jolts_with_diagnostics)

# View job openings by state for latest period
job_openings <- jolts_data[dataelement_text == "Job openings" & 
                          date == max(date)]
}
}
