% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bls_text.R
\name{read_bls_text}
\alias{read_bls_text}
\title{Read Plain Text Files from BLS Website}
\usage{
read_bls_text(url)
}
\arguments{
\item{url}{A character string specifying the full URL to a text file on the
BLS website (e.g., \url{https://download.bls.gov/pub/time.series/}).}
}
\value{
A character vector where each element is one line from the text file.
  Lines are split on newline characters (\code{\\n}).
}
\description{
Downloads and reads plain text files from the Bureau of Labor Statistics (BLS)
website. This is a companion function to \code{fread_bls()} that handles text
files rather than structured data tables. The function uses custom headers to
ensure reliable access to BLS resources.
}
\details{
This function is designed to read descriptive text files from BLS, such as
README files or database overview documents. It sends an HTTP GET request
with browser-like headers to ensure compatibility with BLS server requirements.

The function will stop with an error if the HTTP request fails (e.g., if the
URL is invalid or the server is unavailable).
}
\examples{
\donttest{
# Read the overview file for Current Employment Statistics
ces_overview <- read_bls_text(
  "https://download.bls.gov/pub/time.series/ce/ce.txt"
)

# Display the first few lines
head(ces_overview)
}

}
\seealso{
\code{\link{bls_overview}} for formatted database overviews,
\code{\link{load_bls_dataset}} for loading complete datasets
}
\keyword{internal}
