% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNrich.R
\name{parm_Ttest}
\alias{parm_Ttest}
\title{Testing the equality regression coefficients}
\usage{
parm_Ttest(
  Data_h,
  coef_H,
  BNs_H,
  Data_d,
  coef_D,
  BNs_D,
  Var_mat_Bh,
  Var_mat_Bd,
  Pathway.id1
)
}
\arguments{
\item{Data_h}{A list contains data frames related to control objects for any BN}

\item{coef_H}{A list contains parameters of BN_h}

\item{BNs_H}{A list contains BNs learned by control objects data}

\item{Data_d}{A list contains data frames related to disease objects for any BN}

\item{coef_D}{A list contains parameters of BN_d}

\item{BNs_D}{A list contains BNs learned by disease objects data}

\item{Var_mat_Bh}{A list contains covariance matrixes for any node of BN_h}

\item{Var_mat_Bd}{A list contains covariance matrixes for any node of BN_d}

\item{Pathway.id1}{A vector contains modified KEEG pathway IDs}
}
\value{
A data frame contains T-test results for all parameters in final BNs
}
\description{
t-test for equality the corresponging parameters in any BN
}
\examples{
#All the 187 preprocessed signaling pathways can be entered in analysis by fetch_data_file().
#But here you enter a subset of those pathways to see how this package works.
files <- system.file("extdata", "test_files_to_start.RData", package = "BNrich", mustWork = TRUE)
load(files)
Data <- system.file("extdata", "Test_DATA.RData", package = "BNrich", mustWork = TRUE)
load(Data)
uni_Result <- unify_path(dataH, dataD, MapkG = sub_mapkG, Pathway.id = path.id)
M1 <- uni_Result$mapkG1
BN <- BN_struct(M1)
data_h1 <- uni_Result$data_h
data_d1 <- uni_Result$data_d
LASSO_Result <- LASSO_BN(BN = BN , data_h = data_h1 , data_d = data_d1)
BN_h1 <- LASSO_Result$BN_h
BN_d1 <- LASSO_Result$BN_d
esti_result <- esti_par(BN_H = BN_h1, BN_D = BN_d1, data_h = data_h1, data_d = data_d1)
BNs_H <- esti_result$BNs_h
BNs_D <- esti_result$BNs_d
coef_h <- esti_result$coef_h
coef_d <- esti_result$coef_d
var_result <- var_mat(data_h1, coef_h,  BNs_H, data_d1, coef_d, BNs_D)
Var_H = var_result$var_mat_Bh
Var_D = var_result$var_mat_Bd
path.id1 <- uni_Result$pathway.id1
Ttest_result <- parm_Ttest(data_h1, coef_h, BNs_H, data_d1, coef_d, BNs_D, Var_H, Var_D, path.id1)
}
