% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bconsumerrisk.R
\name{bconsumerrisk}
\alias{bconsumerrisk}
\title{Consumer's Risk for Binomial RDT}
\usage{
bconsumerrisk(n, c, pi, R)
}
\arguments{
\item{n}{RDT sample size.}

\item{c}{Maximum allowable failures.}

\item{pi}{Failure probability.}

\item{R}{Lower level reliability requirement.}
}
\value{
Probability of consumer's risk
}
\description{
Define the consumer's risk function which gets the probability of passing the test when the lower level reliability requirement is not satisfied (for binomial RDT).
}
\examples{
pi <- pi_MCSim_beta(M = 1000, seed = 10, a = 1, b = 1)
bconsumerrisk(n = 10, c = 2, pi = pi, R = 0.8);
}
\seealso{
\code{\link{bcore}} for getting the core probability of passting the test;
\code{\link{boptimal_n}} for getting the optimal test sample size;
\code{\link{bIndicator}} for getting the binary indicator;
}
