% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartiteGibbs.R
\name{bipartiteGibbs}
\alias{bipartiteGibbs}
\title{Gibbs Sampler Used for Beta Record Linkage}
\usage{
bipartiteGibbs(cd, nIter = 1000, a = 1, b = 1, aBM = 1, bBM = 1, seed = 0)
}
\arguments{
\item{cd}{a list with the same structure as the output of the function \code{\link{compareRecords}}, containing: 
\describe{
  \item{\code{comparisons}}{
                        matrix with \code{n1*n2} rows, where the comparison pattern for record pair \eqn{(i,j)}
                    appears in row \code{(j-1)*n1+i}, for \eqn{i} in \eqn{{1,\dots,n1}}, and \eqn{j} in \eqn{{1,\dots,n2}}.  
                    A comparison field with \eqn{L+1} levels of disagreement, 
                    is represented by \eqn{L+1} columns of TRUE/FALSE indicators.  Missing comparisons are coded as FALSE,
                    which is justified under an assumption of ignorability of the missing comparisons, see Sadinle (2017).
                    }
  \item{\code{n1,n2}}{the datafile sizes, \code{n1 = nrow(df1)} and \code{n2 = nrow(df2)}.}
  \item{\code{nDisagLevs}}{a vector containing the number of levels of
                     disagreement per comparison field.}
  \item{\code{compFields}}{a data frame containing the names of the fields in the datafiles used in the comparisons 
                     and the types of comparison.}
}}

\item{nIter}{number of iterations of Gibbs sampler.}

\item{a, b}{hyper-parameters of the Dirichlet priors for the \eqn{m} and \eqn{u} parameters
    in the model for the comparison data among matches and non-matches, respectively.
    These can be vectors with as many 
entries as disagreement levels among all comparison fields.  If specified as positive constants, they 
get recycled to the required length.  If not specified, flat priors are taken.}

\item{aBM, bBM}{hyper-parameters of beta prior on bipartite matchings. Default is \code{aBM=bBM=1}.}

\item{seed}{seed to be used for pseudo-random number generation.  By default it sets \code{seed=0}.}
}
\value{
a list containing: 
\describe{
  \item{\code{Z}}{matrix with \code{n2} rows and \code{nIter} columns containing the chain of bipartite matchings.  
		A number smaller or equal to \code{n1} in row \code{j} indicates the record in datafile 1 to which record \code{j} in datafile 2 
		is linked at that iteration, otherwise \code{n1+j}.
		}
  \item{\code{m,u}}{chain of \eqn{m} and \eqn{u} parameters in the model for the comparison data among matches and non-matches, respectively.}
}
}
\description{
Run a Gibbs sampler to explore the posterior distribution of bipartite matchings 
that represent the linkage of the datafiles in beta record linkage.
}
\examples{
data(twoFiles)

myCompData <- compareRecords(df1, df2, flds=c("gname", "fname", "age", "occup"), 
                             types=c("lv","lv","bi","bi"))

chain <- bipartiteGibbs(myCompData)
}
\references{
Mauricio Sadinle (2017). Bayesian Estimation of Bipartite Matchings for Record Linkage. \emph{Journal of the
American Statistical Association} 112(518), 600-612. [\href{https://doi.org/10.1080/01621459.2016.1148612}{Published}] [\href{https://arxiv.org/abs/1601.06630}{arXiv}]
}
