% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_scheme.R
\name{hybridSchemeCovarianceMatrix}
\alias{hybridSchemeCovarianceMatrix}
\title{Hybrid scheme covariance matrix}
\usage{
hybridSchemeCovarianceMatrix(kappa, n, alpha)
}
\arguments{
\item{kappa}{number of terms needed for the lower sum in the hybrid scheme.}

\item{n}{number of observations per unit of time, n = 1/delta.}

\item{alpha}{smoothness parameter used in the BSS simulation.}
}
\value{
Returns the covariance matrix for the lower sum in the hybrid scheme calculations.
The dimensions of the covariance matrix will be (kappa + 1) by (kappa + 1).
}
\description{
Generates the covariance matrix used in simulating Brownian semistationary processes by
the hybrid scheme.
}
\examples{

kappa <- 3
n <- 100
alpha <- -0.2

hybridSchemeCovarianceMatrix(kappa, n, alpha)


}
