% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_inference.R
\name{predictBSTFA}
\alias{predictBSTFA}
\title{Estimate/predict values of the time series at a specific location.}
\usage{
predictBSTFA(
  out,
  location = NULL,
  type = "mean",
  ci.level = c(0.025, 0.975),
  new_x = NULL,
  pred.int = FALSE
)
}
\arguments{
\item{out}{Output from BSTFA or BSTFAfull.}

\item{location}{Either a single integer indicating the location in the data set to provide predictions or a vector of length 2 providing the longitude and latitude of the new location. If \code{location=NULL} (default), the function will return predictions for all in-sample locations.}

\item{type}{One of \code{all}, \code{mean} (default), \code{median}, \code{ub}, or \code{lb} indicating which summary statistic of the predicted values to return.}

\item{ci.level}{If \code{type='lb'} or \code{'ub'}, the percentiles for the posterior interval.}

\item{new_x}{If the original model included covariates \code{x}, include the same covariates for prediction \code{location}.}

\item{pred.int}{Logical scalar indicating whether to include additional uncertainty for posterior predictive intervals (\code{TRUE}) or not (\code{FALSE}; default -- intervals represent posterior probabilities around the mean of \code{location}).}
}
\value{
A matrix or vector of estimated/predicted values for \code{location}.
}
\description{
Estimate/predict values of the time series at a specific location.
}
\examples{
data(out.sm)
attach(out.sm)
loc1means <- predictBSTFA(out.sm, location=1, pred.int=FALSE)
}
\author{
Candace Berrett and Adam Simpson
}
