% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_get.R
\name{get.defaults}
\alias{get.defaults}
\title{Retrieve Default Arguments for BTSR Package Functions}
\usage{
get.defaults(fun)
}
\arguments{
\item{fun}{Character string specifying the function name to examine
(case-sensitive).}
}
\value{
Invisibly returns a data frame with two columns:
\itemize{
\item \code{Argument}: Name of the function parameter
\item \code{Default}: Default value or \code{"(no default)"} string if no
default exists
}
The function primarily prints a formatted table of the results to the
console.
}
\description{
Extracts and displays the default argument values for any function in the
BTSR package, including both exported and non-exported functions.
}
\examples{
\dontrun{
# View defaults for BTSR.fit function
get.defaults("BARFIMA.fit")

# Capture the results for later use
defaults <- get.defaults("BARFIMA.fit")
}

}
