% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BT_CV_Predict.R
\name{predict.BTCVFit}
\alias{predict.BTCVFit}
\title{Predictions for CV fitted BT models.}
\usage{
\method{predict}{BTCVFit}(object, data, cv.folds, folds, best.iter.cv, ...)
}
\arguments{
\item{object}{a \code{\link{BTCVFit}} object containing CV BT models.}

\item{data}{the database on which one wants to predict the different CV BT models.}

\item{cv.folds}{a positive integer specifying the number of folds to be used in cross-validation of the BT fit.}

\item{folds}{vector of integers specifying which row of data belongs to which cv.folds.}

\item{best.iter.cv}{the optimal number of trees with a CV approach.}

\item{\dots}{not currently used.}
}
\value{
Returns a vector of predictions for each cv folds.
}
\description{
Compute predictions from cross-validated Boosting Trees model.
}
\details{
This function has not been coded for public usage but rather to assess the cross-validation performances.
}
\references{
M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |: GLMs and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries ||: Tree-Based Methods and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |||: Neural Networks and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2022). \strong{Response versus gradient boosting trees, GLMs and neural networks under Tweedie loss and log-link}.
Accepted for publication in \emph{Scandinavian Actuarial Journal}.

M. Denuit, J. Huyghe and J. Trufin (2022). \strong{Boosting cost-complexity pruned trees on Tweedie responses: The ABT machine for insurance ratemaking}.
Paper submitted for publication.

M. Denuit, J. Trufin and T. Verdebout (2022). \strong{Boosting on the responses with Tweedie loss functions}. Paper submitted for publication.
}
\seealso{
\code{\link{BT}}, \code{\link{BTFit}}.
}
\author{
Gireg Willame \email{gireg.willame@gmail.com}

\emph{This package is inspired by the \code{gbm3} package. For more details, see \url{https://github.com/gbm-developers/gbm3/}}.
}
\keyword{internal}
