% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BallMapper.R
\name{pointToBallList}
\alias{pointToBallList}
\title{Produce a two column list. The first column contain the number of point (possibly with repetitions), the second one contains the number of landmark points that cover it.
For example, let us assume that point 1 is covered by landmark 1 and 2, and point 2 is covered by the landmark 2. In this case the obtained list is of a form:
1 1
1 2
2 2
This list can be used for a further analysis of various parts of Ball Mapper graph.}
\usage{
pointToBallList(coverageFromBallMapper)
}
\arguments{
\item{coverageFromBallMapper, }{a coverage parameter of an output from BallMapper function}
}
\value{
List of landmarks covering each point, as described above.
}
\description{
Produce a two column list. The first column contain the number of point (possibly with repetitions), the second one contains the number of landmark points that cover it.
For example, let us assume that point 1 is covered by landmark 1 and 2, and point 2 is covered by the landmark 2. In this case the obtained list is of a form:
1 1
1 2
2 2
This list can be used for a further analysis of various parts of Ball Mapper graph.
}
\examples{
var <- seq(from=0,to=6.3,by=0.1)
points <- as.data.frame( cbind( sin(var),cos(var) ) )
values <- as.data.frame( sin(var) )
epsilon <- 0.25
l <- BallMapper(points,values,epsilon)
list <- pointToBallList(l$coverage)
}
