% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_sets}
\alias{add_sets}
\title{Add sets to a TidySet}
\usage{
add_sets(object, sets, ...)
}
\arguments{
\item{object}{A \code{\link{TidySet}} object}

\item{sets}{A character vector of sets to be added.}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}
}
\value{
A \code{\link{TidySet}} object with the new sets.
}
\description{
Functions to add sets. If the sets are new they are added,
otherwise they are omitted.
}
\note{
\code{add_sets} doesn't set up any other information about the sets.
Remember to add/modify them if needed with \code{\link{mutate}} or \code{\link{mutate_set}}
}
\examples{
x <- list("a" = letters[1:5], "b" = LETTERS[3:7])
a <- tidySet(x)
b <- add_sets(a, "fg")
sets(b)
}
\seealso{
Other add_*: 
\code{\link{add_elements}()},
\code{\link{add_relations}()}
}
\concept{add_*}
