% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RegDosePoints.R
\name{plot_RegDosePoints}
\alias{plot_RegDosePoints}
\title{Plot Regeneration Dose Points}
\usage{
plot_RegDosePoints(object, nrow = 3L, ncol = nrow, ...)
}
\arguments{
\item{object}{\link{list} (\strong{required}): input object created by \link{create_DataFile}}

\item{nrow}{\link{integer} (\emph{with default}): number of rows used for the plot panel}

\item{ncol}{\link{integer} (\emph{with default}): number of columns in the plot panel}

\item{...}{further plot arguments passed down to modify the plot output. Supported
arguments are \code{xlab}, \code{ylab}, \code{type}, \code{pch}, \code{col}, \code{cex}}
}
\value{
The function returns a plot
}
\description{
Simple plot functionality to visualise $L_x/T_x$ values against the dose extracted
from data created by \link{create_DataFile}
}
\examples{

data(DATA3,envir = environment())
plot_RegDosePoints(DATA3)

}
\seealso{
\link{create_DataFile}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
}
