% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayenet.R
\name{Bayenet}
\alias{Bayenet}
\title{fit a robust Bayesian elastic net variable selection model for genetic study.}
\usage{
Bayenet(
  X,
  Y,
  clin,
  max.steps = 10000,
  robust = TRUE,
  sparse = TRUE,
  penalty = c("lasso", "elastic net"),
  debugging = FALSE
)
}
\arguments{
\item{X}{the matrix of predictors (genetic factors). Each row should be an observation vector.}

\item{Y}{the continuous response variable.}

\item{clin}{a matrix of clinical variables. Clinical variables are not subject to penalize. Clinical variables will be centered and a column of 1 will be added to the Clinical matrix as the intercept.}

\item{max.steps}{the number of MCMC iterations.}

\item{robust}{logical flag. If TRUE, robust methods will be used.}

\item{sparse}{logical flag. If TRUE, spike-and-slab priors will be used to shrink coefficients of irrelevant covariates to zero exactly.}

\item{penalty}{two choices are available. "lasso" for lasso penalty. "elastic net" for elastic net penalty.}

\item{debugging}{logical flag. If TRUE, progress will be output to the console and extra information will be returned.}
}
\value{
an object of class `Bayenet' is returned, which is a list with component:
\item{posterior}{the posterior samples of coefficients from the MCMC.}
\item{coefficient}{the estimated value of coefficients.}
\item{burn.in}{the total number of burn-ins.}
\item{iterations}{the total number of iterations.}
\item{design}{the design matrix of all effects.}
}
\description{
fit a robust Bayesian elastic net variable selection model for genetic study.
}
\details{
Consider the data model described in "\code{\link{dat}}":
\deqn{Y_{i} = \alpha_{0} + \sum_{k=1}^{q}\gamma_{k}C_{ik}+\sum_{j=1}^{p}\beta_{j}X_{ij}+\epsilon_{i},}
where \eqn{\alpha_{0}} is the intercept, \eqn{\gamma_{k}}'s and \eqn{\beta_{j}}'s are the regression coefficients corresponding to effects of clinical factors and genetic variants, respectively.

When penalty="elastic net" (default), the elastic net penalty is adopted. If penalty="lasso", the lasso penalty is used.

When sparse=TRUE (default), spike--and--slab priors are imposed to identify important main and interaction effects. If sparse=FALSE, Laplacian shrinkage will be used.

When robust=TRUE (default), the distribution of \eqn{\epsilon_{i}} is defined as a Laplace distribution with density
\eqn{
f(\epsilon_{i}|\nu) = \frac{\nu}{2}\exp\left\{-\nu |\epsilon_{i}|\right\}
}, (\eqn{i=1,\dots,n}), which leads to a Bayesian formulation of LAD regression. If robust=FALSE, \eqn{\epsilon_{i}} follows a normal distribution.

Both \eqn{X} and \eqn{clin} will be standardized before the generation of interaction terms to avoid the multicollinearity between main effects and interaction terms.

Please check the references for more details about the prior distributions.
}
\examples{
data(dat)

max.steps=5000
fit= Bayenet(X, Y, clin, max.steps, penalty="lasso")

## coefficients of parameters
fit$coefficient

## Estimated values of main G effects 
fit$coefficient$G

## Estimated values of clincal effects 
fit$coefficient$clin


}
\references{
Lu, X. and Wu, C. (2025). Robust Bayesian elastic net with spike-and-slab priors.
}
\seealso{
\code{\link{Selection}}
}
\keyword{models}
