% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP2D.R
\name{BP2D}
\alias{BP2D}
\title{Bayesian estimation using two dimensions Bernstein polynomial}
\usage{
BP2D(
  prior,
  ages,
  years,
  disease,
  population,
  Iterations = 2e+05,
  n_chain = 5,
  n_cluster = 1,
  nn = 2,
  interval = 100,
  RJC = 0.35,
  seed = TRUE,
  set = 1,
  double = 4
)
}
\arguments{
\item{prior}{prior=(n0,alpha,L) where alpha is a Poisson parameter,n0 is upper bound of alpha
L can be every number which is bigger than one.}

\item{ages}{Range of ages.}

\item{years}{Range of years.}

\item{disease}{Disease matrix.}

\item{population}{Population matrix.}

\item{Iterations}{Iterations of chain.}

\item{n_chain}{Number of Markov chain.}

\item{n_cluster}{This parameter means number of cores, five cores is recommended.(default: n_cluster=1).}

\item{nn}{The parameter nn is lower bound of alpha.}

\item{interval}{Each hundreds save one coefficient.}

\item{RJC}{Control parameter for transfer dimension.}

\item{seed}{Set seed yes or not.}

\item{set}{Choose seed.(defaults:set=1)}

\item{double}{If R.hat >1.1 then double the iterations of times.}
}
\value{
This function will return Bayesian estimate of incidence,Stored parameters,posterior mean,posterior max and table.
\item{Fhat}{Bayesian estimate of incidence.}
\item{chain}{Bayesian estimate of posterior p-value mean.}
\item{maxchain}{Bayesian estimate of posterior p-value max.}
\item{store_coefficients}{Two dimensional Bernstein coefficients.}
\item{output}{When M-H algorithm ends,contruct the table which contains norm,mean of Fhat,maximum of Fhat,R.hat,iterations,P-value and elasped time.}
}
\description{
This function runs Metropolis-Hasting algorithm which is given setting prior and data.This algorithm starts storing coefficients when it runs halfway,so we use second halves of coefficients compute Rhat to check convergence.
}
\examples{
\donttest{
# ---------------------------------------- #
library(BayesBP)
ages<-35:85
years<-1988:2007
prior<-c(10,5,2)
data(simulated_data_1)
disease<-simulated_data_1$disease
population<-simulated_data_1$population
result<-BP2D(prior,ages,years,disease,population)
# ---------------------------------------- #
# Bernstein basis
basis<-BPbasis(ages,years,10)
pdbasis1<-PD_BPbasis(ages,years,10,by = 1)
pdbasis2<-PD_BPbasis(ages,years,10,by = 2)
# Bernstein polynomial
coef<-result$store_coefficients$chain_1[[1]]
BPFhat(coef,ages,years,basis)
PD_BPFhat(coef,ages,years,pdbasis1,by = 1)
PD_BPFhat(coef,ages,years,pdbasis2,by = 2)
# Credible interval
Credible_interval(result)
PD_Credible_interval(result,by = 1)
PD_Credible_interval(result,by = 2)
# ---------------------------------------- #
# Given four prior set
ages<-35:85
years<-1988:2007
data(simulated_data_2)
disease<-simulated_data_2$disease
population<-simulated_data_2$population
p<-expand.grid(n0=c(10,20),alpha=c(5,10),LL=c(2,4))
prior_set<-p[p$n0==p$alpha*2,]
result_list<-paste0('result',1:nrow(prior_set))
for (i in seq_len(nrow(prior_set))) {
   prior<-prior_set[i,]
   assign(result_list[i],BP2D(prior,ages,years,disease,population))
   write.BP(get(result_list[i]),sprintf('\%s.xlsx',result_list[i]))
}
tab<-BP2D_table(result_list)
write.BPtable(tab,'result_table.xlsx')
# ---------------------------------------- #
}
}
\references{
Li-Chu Chien,Yuh-Jenn Wu,Chao A. Hsiung,Lu-Hai Wang,I-Shou Chang(2015).Smoothed Lexis Diagrams With Applications to Lung and Breast Cancer Trends in Taiwan,Journal of the American Statistical Association, Taylor & Francis Journals, vol. 110(511), pages 1000-1012, September.
}
\seealso{
Other Bayesain estimate: 
\code{\link{BP2D_coef}()},
\code{\link{BP2D_table}()}
}
\concept{Bayesain estimate}
