% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_BrainMap.R
\name{LL2_kappa}
\alias{LL2_kappa}
\title{Compute part of kappa log-likelihood}
\usage{
LL2_kappa(
  kappa,
  Amat,
  Fmat,
  Gmat,
  GFinvG,
  OplusW,
  u,
  v,
  C1 = 1/(4 * pi),
  Q = NULL
)
}
\arguments{
\item{kappa}{Value of kappa for which to compute log-likelihood}

\item{Amat}{Mesh projection matrix}

\item{Fmat}{Matrix used in computation of SPDE precision}

\item{Gmat}{Matrix used in computation of SPDE precision}

\item{GFinvG}{Matrix used in computation of SPDE precision}

\item{OplusW}{Sparse matrix containing estimated values of RHS of trace in part 2 of log-likelihood. In common smoothness model, represents the sum over q=1,...,Q.}

\item{u}{Vector needed for part 3 of log-likelihood}

\item{v}{Vector needed for part 3 of log-likelihood}

\item{C1}{For the unit variance case, \eqn{\tau^2 = C1/\kappa^2}, where \eqn{C1 = 1/(4\pi)} when \eqn{\alpha=2}, \eqn{\nu=1}, \eqn{d=2}}

\item{Q}{Equal to the number of networks for the common smoothness model, or NULL for the network-specific smoothness model}
}
\value{
Value of log-likelihood at logkappa
}
\description{
Compute part of log-likelihood involving kappa (or kappa_q) for numerical optimization
}
\details{
This is the function to be maximized in order to determine the MLE for \eqn{\kappa} or the \eqn{\kappa_q}'s in the M-step of the EM algorithm in spatial
model. In the model where \eqn{\kappa_q} can be different for each network \eqn{q}, the optimization function factorizes over the \eqn{\kappa_q}'s. This function computes
the value of the part of the optimization function pertaining to one of the \eqn{\kappa_q}'s.
}
\keyword{internal}
