% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt.cacebayes.R
\name{plt.acf}
\alias{plt.acf}
\title{this plot function creates an acf plot}
\usage{
plt.acf(obj, param = c("CACE"), trialnumber = 1, ...)
}
\arguments{
\item{obj}{a model object, returned by \code{cace.meta.c}, \code{cace.meta.ic},
or \code{cace.study}}

\item{param}{list of parameters to plot}

\item{trialnumber}{indicator for which trial number of the mcmc samples
to use. The default is \code{1}}

\item{...}{optional parameters to pass into the \code{acf} function
from the \code{stats} library.}
}
\value{
It returns an acf plot in an \code{R} plot window.
}
\description{
This function creates an acf (Autocorrelation Function) plot for a model object with the type attribute \code{cace.Bayes}.
}
\examples{
\donttest{
out.meta.c <- cace.meta.c(data = epidural_c, conv.diag = TRUE, 
mcmc.samples = TRUE, study.specific = TRUE)
plt.acf(obj=out.meta.c)
}
}
