% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesCTDesigncode.R
\name{print.bayes_ctd_array}
\alias{print.bayes_ctd_array}
\title{Print Data from Two Arm Bayesian Clinical Trial Simulation.}
\usage{
\method{print}{bayes_ctd_array}(
  x = NULL,
  measure = "power",
  tab_type = "WX|YZ",
  subj_per_arm_val = NULL,
  a0_val = NULL,
  effect_val = NULL,
  rand_control_diff_val = NULL,
  print_chg_warn = 1,
  ...
)
}
\arguments{
\item{x}{Name of object of class \code{bayes_ctd_array} containing
data from clinical trial simulation.}

\item{measure}{Must be equal to \code{power}, \code{est}, \code{var}, \code{bias},
or \code{mse}.  Default is \code{power}.  Case does not matter.}

\item{tab_type}{A character string that must equal \code{WX|YZ}, \code{WY|XZ},
\code{WZ|XY}, \code{XY|WZ}, \code{XZ|WY}, \code{YZ|WX}, \code{ZX|WY}, \code{XW|YZ},
\code{YW|XZ}, \code{YX|WZ}, \code{ZW|XY}, \code{ZX|WY}, \code{ZY|WX} when
\code{x} is generated by \code{historic_sim()}.  Default is
\code{WX|YZ}.  When \code{x} is generated by \code{simple_sim()},
\code{tab_type} is ignored.}

\item{subj_per_arm_val}{Must be non-missing, if \code{x} is generated
by \code{historic_sim()} and sample size is being held constant.
If \code{x} is generated by \code{historic_sim()} and sample size
is being held constant, \code{subj_per_arm_val} must equal a value submitted
to \code{historic_sim()} within the \code{subj_per_arm} parameter.  When
\code{x} is generated by \code{simple_sim()}, \code{subj_per_arm_val}
is ignored.}

\item{a0_val}{Must be non-missing, if \code{x} is generated
by \code{historic_sim()} and a0, the power prior parameter, is being held
constant.  If \code{x} is generated by \code{historic_sim()} and
a0 is being held constant, \code{a0_val} must equal a value submitted
to \code{historic_sim()} within the \code{a0_vals} parameter.  When
\code{x} is generated by \code{simple_sim()}, \code{a0_val} is
ignored.}

\item{effect_val}{Must be non-missing, if \code{x} is generated
by \code{historic_sim()} and effect is being held constant.  If
\code{x} is generated by \code{historic_sim()} and effect is being
held constant, \code{effect_val} must equal a value submitted to
\code{historic_sim()} within the \code{effect_vals} parameter.  When
\code{x} is generated by \code{simple_sim()}, \code{effect_val} is
ignored.}

\item{rand_control_diff_val}{Must be non-missing, if \code{x} is
generated by \code{historic_sim()} and differences between randomized
and historical controls are being held constant.  If \code{x}
is generated by \code{historic_sim()} and control differences are being
held constant, \code{rand_control_diff_val} must equal a value submitted to
\code{historic_sim()} within the \code{rand_control_diff} parameter.  When
\code{x} is generated by \code{simple_sim()},
\code{rand_control_diff_val} is ignored.}

\item{print_chg_warn}{A parameter not used by the user, but is used by
\code{plot()} to ensure warnings are not printed twice.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{print()} returns a two dimensional array of simulation results.
}
\description{
\code{print.bayes_ctd_array()} takes an S3 object of class \code{bayes_ctd_array}, and
prints a two dimensional slice from the data generated by a clinical trial simulation
using \code{historic_sim()} or \code{simple_sim()}.
}
\details{
If the object of class \code{bayes_ctd_array} is created by \code{historic_sim()},
then the function \code{print()} allows the user to print user-specified 1- and 2-
dimensional slices of the simulation results based on slicing code described
below.  If the object of class \code{bayes_ctd_array} is created by
\code{simple_sim()}, a basic table of characteristic by sample size and effect is created.

If the object of class \code{bayes_ctd_array} is created by \code{simple_sim()}, then
all four trial characteristics (\code{subj_per_arm_val}, \code{a0_vals},
\code{effect_val}, and \code{rand_control_diff_val}) can be ignored, as can the
parameter defining what type of table to print, \code{tab_type}.  A call to
\code{print()} will require the user to specify a measure (power, est, var, bias,
or mse).

If the object of class \code{bayes_ctd_array} is created by \code{historic_sim()},
a call to \code{print()} will require the user to specify a measure
(power, est, var, bias, or mse) and may require the user to specify a table type.
A table type, \code{tab_type}, will be required if 3 of the 4 trial characteristics
are equal to a vector of 2 or more values.  The table type specification
uses the letters W, X, Y, and Z.  The letter W represents the subject per arm
dimension.  The letter X represents the a0 dimension.  The letter Y represents
the effect dimension.  The letter Z represents the control difference dimension.
To define a slice of the 4-dimensional array, these letters are put into an AB|CD
pattern.  The two letters to the right of the vertical bar define which variables
are held constant.  The two letters to the left of the vertical bar define which
variables are going to show up in the rows (first letter) and in the columns (second
letter).  For example if tab_type equals \code{WX|YZ}, then effect and control
differences will be held constant, while sample size will be represented by the rows
in the generated table and a0 values will be represented by the columns.  The actual
values that are printed in the tables depend on what measure is requested in the
parameter \code{measure}.

\itemize{
  \item \code{tab_type='WX|YZ'}, Sample Size by a0
  \item \code{tab_type='WY|XZ'}, Sample Size by Effect
  \item \code{tab_type='WZ|XY'}, Sample Size by Control Differences
  \item \code{tab_type='XY|WZ'}, a0 by Effect
  \item \code{tab_type='XZ|WY'}, a0 by Control Differences
  \item \code{tab_type='YZ|WX'}, Effect by Control Differences
  \item \code{tab_type='ZX|WY'}, Control Differences by a0
  \item \code{tab_type='XW|YZ'}, a0 by Sample Size
  \item \code{tab_type='YW|XZ'}, Effect by Sample Size
  \item \code{tab_type='YX|WZ'}, Effect by a0
  \item \code{tab_type='ZW|XY'}, Control Differences by Sample Size
  \item \code{tab_type='ZY|WX'}, Control Differences by Effect
}

It is very important to populate the values of \code{subj_per_arm_val},
\code{a0_vals}, \code{effect_val}, and \code{rand_control_diff_val} correctly given
the value of tab_type, when the object of class \code{bayes_ctd_array} is created by
\code{historic_sim()} and at least 3 of the four parameters have more than one
value.  On the other hand, if 2 or more of the four parameters have only one value,
then \code{subj_per_arm_val}, \code{a0_vals}, \code{effect_val},
\code{rand_control_diff_val}, as well as \code{tab_type} can be ignored.  If the last
two letters are \code{YZ}, then \code{effect_val} and \code{rand_control_diff_val}
must be populated.  If the last two letters are \code{XZ}, then \code{a0_vals} and
\code{rand_control_diff_val} must be populated.  If the last two letters are
\code{XY}, then \code{a0_vals} and \code{effect_val} must be populated.  If the last
two letters are \code{WZ}, then \code{sample_val} and \code{rand_control_diff_val}
must be populated.  If the last two letters are \code{WY}, then \code{sample_size_val}
and \code{effect_val} must be populated.  If the last two letters are \code{WX}, then
\code{sample_size_val} and \code{a0_vals} must be populated.

If the object of class \code{bayes_ctd_array} is created by \code{simple_sim()}, the
parameters \code{tab_type}, \code{subj_per_arm_val}, \code{a0_vals}, \code{effect_val},
and \code{rand_control_diff_val} are ignored.
}
\examples{
#Run a Weibull simulation, using simple_sim().
#For meaningful results, trial_reps needs to be much larger than 2.
weibull_test <- simple_sim(trial_reps = 2, outcome_type = "weibull",
                           subj_per_arm = c(50, 100, 150, 200),
                           effect_vals = c(0.6, 1, 1.4),
                           control_parms = c(2.82487,3),
                           time_vec = NULL, censor_value = NULL,
                           alpha = 0.05, get_var = TRUE,
                           get_bias = TRUE, get_mse = TRUE,
                           seedval=123, quietly=TRUE)

#Tabulate the simulation results for power.
test_table <- print(x=weibull_test, measure="power",
                    tab_type=NULL, subj_per_arm_val=NULL, a0_val=NULL,
                    effect_val=NULL, rand_control_diff_val=NULL)
print(test_table)

#Tabulate the simulation results for estimates.
print(x=weibull_test, measure="est")

#Tabulate the simulation results for variance.
print(x=weibull_test, measure="var")

#Tabulate the simulation results for bias.
print(x=weibull_test, measure="bias")

#Tabulate the simulation results for mse.
print(x=weibull_test, measure="mse")

\donttest{
#Run another weibull simulation, using historic_sim().
#Note: historic_sim() can take a while to run.
#Generate a sample of historical data for use in example.
set.seed(2250)
SampleHistData <- genweibulldata(sample_size=60, scale1=2.82487,
                                 hazard_ratio=0.6, common_shape=3,
                                 censor_value=3)
histdata <- subset(SampleHistData, subset=(treatment==0))
histdata$id <- histdata$id+10000

#For meaningful results, trial_reps needs to be larger than 100.
weibull_test2 <- historic_sim(trial_reps = 100, outcome_type = "weibull",
                              subj_per_arm = c(50, 100, 150, 200, 250),
                              a0_vals = c(0, 0.33, 0.67, 1),
                              effect_vals = c(0.6, 1, 1.4),
                              rand_control_diff = c(0.8, 1, 1.2),
                              hist_control_data = histdata, time_vec = NULL,
                              censor_value = 3, alpha = 0.05, get_var = TRUE,
                              get_bias = TRUE, get_mse = TRUE, seedval=123,
                              quietly=TRUE)

#Tabulate the simulation results for power.
test_table <- print(x=weibull_test2, measure="power",
                    tab_type="WX|YZ", effect_val=0.6,
                    rand_control_diff_val=1.0)
print(test_table)

#Tabulate the simulation results for estimates.
print(x=weibull_test2, measure="est", tab_type="WX|YZ",
      effect_val=0.6, rand_control_diff_val=1.0)

#Tabulate the simulation results for variance.
print(x=weibull_test2, measure="var", tab_type="WX|YZ",
      effect_val=0.6, rand_control_diff_val=1.0)

#Tabulate the simulation results for bias.
print(x=weibull_test2, measure="bias", tab_type="WX|YZ",
      effect_val=0.6, rand_control_diff_val=1.0)

#Tabulate the simulation results for mse.
print(x=weibull_test2, measure="mse", tab_type="WX|YZ",
      effect_val=0.6, rand_control_diff_val=1.0)
}

\donttest{
#Run a Bernoulli simulation, using historic_sim().
#Generate a sample of historical Bernoulli data for use in example.
set.seed(2250)
samplehistdata <- genbernoullidata(sample_size=60, prob1=0.6, odds_ratio=0.6)
histdata <- subset(samplehistdata, subset=(treatment==0))
histdata$id <- histdata$id+10000

#For meaningful results, trial_reps needs to be larger than 100.
bernoulli_test <- historic_sim(trial_reps = 100, outcome_type = "bernoulli",
                              subj_per_arm = c(150),
                              a0_vals = c(1.0),
                              effect_vals = c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0),
                              rand_control_diff = c(1.8),
                              hist_control_data = histdata, time_vec = NULL,
                              censor_value = 3, alpha = 0.05, get_var = TRUE,
                              get_bias = TRUE, get_mse = TRUE, seedval=123,
                              quietly=TRUE)
test_table <- print(x=bernoulli_test, measure="power",
                    tab_type=NULL, effect_val=NULL,
                    subj_per_arm_val=NULL)
print(test_table)

#If only one or two of the subj_per_arm, a0_vals, effect_vals, or
#rand_control_diff parameters have length greater than 1, then
#only bayes_ctd_array and measure parameters are needed.
#Tabulate the simulation results for estimates.
print(x=bernoulli_test, measure="est")

#Tabulate the simulation results for variance.
print(x=bernoulli_test, measure="var")

#Tabulate the simulation results for bias.
print(x=bernoulli_test, measure="bias")

#Tabulate the simulation results for mse.
print(x=bernoulli_test, measure="mse")
}

}
