% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSampleNormal1.R
\name{OneSampleNormal1}
\alias{OneSampleNormal1}
\title{One sample Normal model with one-parameter unknown, given variance}
\usage{
OneSampleNormal1(
  prior,
  N = 100,
  mu0,
  mu1,
  var,
  d = 0,
  ps = 0.95,
  pf = 0.05,
  alternative = c("less", "greater"),
  seed = 202209,
  sim = 5000
)
}
\arguments{
\item{prior}{A list of length 2 containing the distributional information of the prior.
The first element is a number specifying the type of prior. Options are
\enumerate{
\item DIP ;
\item Normal(mu0,var/n0), where mu0 = prior mean, var = the known variance}
The second elements of the list is the parameter n0.}

\item{N}{The planned sample size.}

\item{mu0}{The null mean value, which could be taken as the standard or current mean.}

\item{mu1}{The mean value of the new treatment.}

\item{var}{The variance}

\item{d}{The target improvement (minimal clinically meaningful difference).}

\item{ps}{The efficacy boundary (upper boundary).}

\item{pf}{The futility boundary (lower boundary).}

\item{alternative}{less (lower values imply greater efficacy) or greater (larger
values imply greater efficacy).}

\item{seed}{The seed for simulations.}

\item{sim}{The number of simulations.}
}
\value{
A list of the arguments with method and computed elements.
}
\description{
For a given planned sample size, the efficacy and futility boundaries,
return the power, the type I error, the expected sample size and its
standard deviation, the probability of reaching the efficacy and futility boundaries.
}
\examples{
# with traditional Bayesian prior Beta(1,1)
OneSampleNormal1(list(2,6), N = 100, mu0 = 100, mu1 = 95, var=15, d = 0.05,
                  ps = 0.95, pf = 0.05, alternative = "less",
                  seed = 202210, sim = 10)
OneSampleNormal1(list(1,0), N = 100, mu0 = 100, mu1 = 95, var=15, d = 0.05,
                  ps = 0.95, pf = 0.05, alternative = "less",
                  seed = 202210, sim = 10)
}
