% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{likelihood.feedforward_normal}
\alias{likelihood.feedforward_normal}
\title{Use a Normal likelihood for a Feedforward network}
\usage{
likelihood.feedforward_normal(chain, sig_prior)
}
\arguments{
\item{chain}{Network structure obtained using \code{link{Chain}}}

\item{sig_prior}{A prior distribution for sigma defined using
\code{\link{Gamma}}, \code{link{InverGamma}},
\code{\link{Truncated}}, \code{\link{Normal}}}
}
\value{
A list containing the following
\itemize{
    \item juliavar - julia variable containing the likelihood
    \item juliacode - julia code used to create the likelihood
}
}
\description{
This creates a likelihood of the form
\deqn{y_i \sim Normal(net(x_i), \sigma)\;\forall i=1,...,N}
 where the \eqn{x_i} is fed through the network in a standard feedforward way.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  BNN.totparams(bnn)
}

}
