% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_utility.R
\name{custom_template}
\alias{custom_template}
\title{Custom Template Function}
\usage{
custom_template(
  SETUP = NULL,
  LOG_LIKELIHOOD = NULL,
  LOG_PRIOR = NULL,
  compile_template = FALSE
)
}
\arguments{
\item{SETUP}{A character string or vector containing the 
lines of C++ code to be inserted before the computation of log-likelihood.}

\item{LOG_LIKELIHOOD}{A character string or vector containing the 
lines of C++ code to be inserted in the log-likelihood section of 
the template. Should be NULL if no changes are to be made to this section.}

\item{LOG_PRIOR}{A character string or vector containing the 
lines of C++ code to be inserted in the log-prior (of the SD parameter) section of 
the template. Should be NULL if no changes are to be made to this section.}

\item{compile_template}{A indicator of whether the new template should be compiled. default is FALSE.}
}
\value{
A string representing the path to the temporary .so (or .dll) file
  containing the compiled custom C++ code.
}
\description{
This function allows for the dynamic modification of a C++ template
within the BayesGP package. Users can specify custom content for the 
log-likelihood as well as the log-prior of the SD parameter in the template.
}
