% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Calc_Gompertz_LAA}
\alias{Calc_Gompertz_LAA}
\title{Calc_Gompertz_LAA}
\usage{
Calc_Gompertz_LAA(Linf, k, L0, Age)
}
\arguments{
\item{Linf}{A single value of asymptotic length for the Gompertz model}

\item{k}{A single value of the growth completion parameter for the Gompertz model}

\item{L0}{A single value of length-at-birth for the Gompertz model}

\item{Age}{A single value or vector of ages to convert to length based on the Gompertz model}
}
\value{
A vector of length-at-ages
}
\description{
Calc_Gompertz_LAA
}
\examples{
# Calculate length-at-age for a Gompertz growth curve with given parameters
# and age range
Age_Range <-  0:16
Calc_Gompertz_LAA(Linf = 1580, k = 0.21, L0 = 72, Age = Age_Range)
}
