% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Calculate_MCMC_growth_curve}
\alias{Calculate_MCMC_growth_curve}
\title{Calculate_MCMC_growth_curve}
\usage{
Calculate_MCMC_growth_curve(
  obj,
  Model = NULL,
  max.age = NULL,
  probs = c(0.5, 0.75, 0.95)
)
}
\arguments{
\item{obj}{An output from the Estimate_MCMC_Growth function}

\item{Model}{The model used in the Estimate_MCMC_Growth object. Either "VB", "Gom" or "Log".}

\item{max.age}{The max age to estimate growth up until.}

\item{probs}{The percentiles of the results to return. Can be a single value or a vector of
values. A single quantile width is required rather than its range. For example, 50th
percentiles would be width = .5 which would return a lower percentile at .25 and an upper
percentile of .75.}
}
\value{
A tibble that has been formatted using  tidybayes::mean_qi(). This includes
    variables: Age, LAA, .lower, .upper, .width, .point and .interval.
}
\description{
A 'stan.fit' object produced from Estimate_MCMC_Growth is converted to a dataframe
    and structured using requested quantiles. This function takes the list of MCMC results for multiple
    chains, restructures them into a dataframe and calculates quantiles around length-at-age estimates.
    The quantiles are produced using the tidybayes::mean_qi() function and this result is returned from the function.
    This can be conveniently plotted in a ggplot using the geom_lineribbon() function provided in the tidybayes
    package.
}
\examples{
\donttest{
# load example data
data("example_data")
## Biological info - lengths in mm
max_size <- 440
max_size_se <- 5
birth_size <- 0
birth_size_se <- 0.001 # an se cannot be zero

# Use the function to estimate the rstan model
fit <- Estimate_MCMC_Growth(data = example_data,
                            Model = "VB" ,
                            iter = 5000,
                            Linf = max_size,
                            Linf.se = max_size_se,
                            L0 = birth_size,
                            sigma.max = 100,
                            L0.se = birth_size_se,
                            k.max = 1,
                            n_cores = 1)

# Use function to return a dataframe of model predictionsfor VB growth model
Calculate_MCMC_growth_curve(fit, Model = "VB" , max.age = max(example_data$Age))
}
}
