% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC_fn.R
\name{DIC_fn}
\alias{DIC_fn}
\title{A function to calculate the DIC of stochastic mortality models using posterior samples}
\usage{
DIC_fn(result)
}
\arguments{
\item{result}{object of type either "fit_result" or "BayesMoFo".}
}
\value{
A numeric value representing the DIC of the mortality model.
}
\description{
Compute the Deviance Information Criterion (DIC) of stochastic mortality models using posterior samples stored in "fit_result" object.
}
\examples{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#a toy example
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models="M1A",n_iter=50,n.adapt=50)

#compute the DIC
DIC_fn(runBayesMoFo_result)
}
\concept{DIC}
\keyword{bayesian}
\keyword{model}
\keyword{selection}
