% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.t.test.two_sample}
\alias{BF10.t.test.two_sample}
\title{Bayes factor for two-sample Bayesian t-test}
\usage{
BF10.t.test.two_sample(
  tval,
  N1,
  N2,
  model,
  location,
  scale,
  dff,
  hypothesis,
  e = NULL
)
}
\arguments{
\item{tval}{Observed t-value from the two-sample t-test.}

\item{N1}{Sample size of group 1.}

\item{N2}{Sample size of group 2.}

\item{model}{Statistical model of the analysis prior under the alternative hypothesis: Normal distribution (\code{"Normal"}), Normal moment (\code{"NLP"}), or scaled t (\code{"t-distribution"}).}

\item{location}{Location parameter for the analysis prior under the alternative hypothesis.}

\item{scale}{Scale parameter for the analysis prior under the alternative hypothesis.}

\item{dff}{Degrees of freedom for the analysis prior under the alternative hypothesis (if applicable).}

\item{hypothesis}{The hypothesis being tested: two-sided (\code{"!="}), right-sided (\code{">"}), or left-sided (\code{"<"}).}

\item{e}{Optional numeric vector specifying bounds for an interval null; used if interval BF is calculated.}
}
\value{
The Bayes factor (BF10) for the two-sample t-test.
}
\description{
Calculate the Bayes factor (BF10) for a two-sample Bayesian t-test, either against a point null or an interval null hypothesis.
}
\examples{
BF10.t.test.two_sample(
  tval = 2.1,
  N1 = 30,
  N2 = 30,
  model = "t-distribution",
  location = 0,
  scale = 0.707,
  dff = 1,
  hypothesis = "!="
)
}
