% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes.R
\name{summaxcusum}
\alias{summaxcusum}
\title{Cpp implementation of sum-cusum and max-cusum for single changepoint detection.}
\usage{
summaxcusum(x, threshold, sum_cusum = TRUE, rescale.var = TRUE)
}
\arguments{
\item{x}{A \eqn{p \times n} matrix representing \eqn{p} data series having \eqn{n} observations each.}

\item{threshold}{The testing threshold to detect the single changepoint. If missing, parameter will be calibrated automatically.}

\item{sum_cusum}{A boolean flag to indicate if sum cusum (sum_cusum=T) or max cusum (sum_cusum=F) is used. Default is TRUE.}

\item{rescale.var}{A boolean flag to indicate if the variance should be rescaled before detecting a changepoint. Default is TRUE.}
}
\description{
Detects one multivariate changepoint in a dataset using the sum-cusum or max-cusum technique.
Solely required is the dataset as first parameter.
The testing threshold ("threshold") is chosen automatically if missing.
The parameter "sum_cusum" (default TRUE) indicates if sum-cusum or max-cusum is used.
}
\examples{
library(BayesProject)
data(testdata)
resSumCusum <- summaxcusum(testdata,sum_cusum=TRUE)
print(resSumCusum$cpt)
resMaxCusum <- summaxcusum(testdata,sum_cusum=FALSE)
print(resMaxCusum$cpt)

}
\references{
Hahn, G., Fearnhead, P., Eckley, I.A. (2020). Fast computation of a projection direction for multivariate changepoint detection. Stat Comput.
}
