% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdEqu.R
\name{ssdEqu}
\alias{ssdEqu}
\title{Sample size determination for replication success based on
    effect size equivalence}
\usage{
ssdEqu(level, dprior, power, margin, searchInt = c(0, 2))
}
\arguments{
\item{level}{1 - confidence level of confidence interval for effect size
difference}

\item{dprior}{Design prior object}

\item{power}{Desired probability of replication success}

\item{margin}{The equivalence margin > 0 for the symmetric equivalence region
around zero}

\item{searchInt}{Interval for numerical search over replication standard
errors}
}
\value{
Returns an object of class \code{"ssdRS"}. See \code{\link{ssd}} for
    details.
}
\description{
This function computes the standard error required to achieve
    replication success with a certain probability and based on effect size
    equivalence of original and replication effect size. Effect size
    equivalence is defined by the confidence interval for the difference
    between the original and replication effect sizes falling within an
    equivalence region around zero defined by the specified margin.
}
\examples{
## specify design prior
to1 <- 0.2
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1, tau = 0.05)
ssdEqu(level = 0.1, dprior = dprior, power = 0.8, margin = 0.2)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}

Anderson, S. F. and Maxwell, S. E. (2016). There's more than one way to
conduct a replication study: Beyond statistical significance. Psychological
Methods, 21(1), 1-12. \doi{10.1037/met0000051}
}
\author{
Samuel Pawel
}
