% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFr.R
\name{BFrSMD}
\alias{BFrSMD}
\title{Generalized replication Bayes factor for SMD effect sizes}
\usage{
BFrSMD(
  to,
  no,
  n1o = no,
  n2o = no,
  tr,
  nr,
  n1r = nr,
  n2r = nr,
  ss,
  type = c("two.sample", "one.sample", "paired")
)
}
\arguments{
\item{to}{\eqn{t}-statistic from the original study}

\item{no}{Sample size of the original study (per group)}

\item{n1o}{Sample size in group 1 of the original study (only required for
two-sample \eqn{t}-test with unequal group sizes)}

\item{n2o}{Sample size in group 2 of the original study (only specify if
unequal group sizes)}

\item{tr}{\eqn{t}-statistic from the replication study}

\item{nr}{Sample size of the replication study (per group)}

\item{n1r}{Sample size in group 1 of the replication study (only required for
two-sample \eqn{t}-test with unequal group sizes)}

\item{n2r}{Sample size in group 2 of the replication study (only required for
two-sample \eqn{t}-test with unequal group sizes)}

\item{ss}{Standard devation of the sceptical prior under
\eqn{H_\mathrm{S}}{HS}. Defaults to \code{0}}

\item{type}{Type of \eqn{t}-test associated with \eqn{t}-statistic. Can be
\code{"two.sample"}, \code{"one.sample"}, \code{"paired"}. Defaults to \code{"two.sample"}}
}
\value{
The generalized replication Bayes factor
\eqn{\mathrm{BF}_{\mathrm{SA}}}{BF_SA}. \eqn{\mathrm{BF}_{\mathrm{SA}} <
    1}{BF_SA < 1} indicates that the data favour the advocate's hypothesis
\eqn{H_{\mathrm{A}}}{HA} (replication success), whereas
\eqn{\mathrm{BF}_{\mathrm{SA}} > 1}{BF_SA > 1} indicates that the data
favour the sceptic's hypothesis \eqn{H_{\mathrm{S}}}{HS} (replication
failure).
}
\description{
Computes the generalized replication Bayes factor for
standardized mean difference (SMD) effect sizes
}
\details{
This function computes the generalized replication Bayes factor for
standardized mean difference (SMD) effect sizes using an exact
\emph{t}-likelihood for the data instead of the normal approximation used in
\code{\link{BFr}} (for details, see Section 4 in Pawel and Held, 2022).
Data from both studies are summarized by \eqn{t}-statistics and sample
sizes. The following types of \eqn{t}-tests are accepted:
\itemize{
\item Two-sample \eqn{t}-test where the SMD represents the standardized
mean difference between two group means (assuming equal variances in
both groups).
\item One-sample \eqn{t}-test where the SMD represents the standardized
mean difference to the null value.
\item Paired \eqn{t}-test where the SMD represents the standardized mean
difference score.
}
}
\examples{
data("SSRPexact")
morewedge2010 <- subset(SSRPexact, study == "Morewedge et al. (2010), Science")
with(morewedge2010,
     BFrSMD(to = to, n1o = n1o, n2o = n2o, tr = tr, n1r = n1r, n2r = n2r, ss = 0))

}
\references{
Verhagen, J. and Wagenmakers, E. J. (2014). Bayesian tests to
quantify the result of a replication attempt. Journal of Experimental
Psychology: General, 145:1457-1475. \doi{10.1037/a0036731}

Pawel, S. and Held, L. (2022). The sceptical Bayes factor for the assessment
of replication success. Journal of the Royal Statistical Society Series
B: Statistical Methodology, 84(3): 879-911. \doi{10.1111/rssb.12491}
}
\seealso{
\code{\link{BFr}}, \code{\link{BFrlogOR}}
}
\author{
Samuel Pawel
}
