% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repPosterior.R
\name{repPosterior}
\alias{repPosterior}
\title{Effect size posterior distribution}
\usage{
repPosterior(
  to,
  so,
  tr,
  sr,
  lower = min(c(to, tr)) - 4/sqrt(1/so^2 + 1/sr^2),
  upper = max(c(to, tr)) + 4/sqrt(1/so^2 + 1/sr^2),
  nGrid = 1000,
  plot = TRUE,
  CI = TRUE,
  ...
)
}
\arguments{
\item{to}{Original effect estimate}

\item{so}{Standard error of the original effect estimate}

\item{tr}{Replication effect estimate}

\item{sr}{Standard error of the replication effect estimate}

\item{lower}{Lower bound of range for which distribution should computed.
Defaults to minimum of \code{to} and \code{tr} minus four times the
pooled standard error}

\item{upper}{Upper bound of range for which distribution should computed.
Defaults to maximum of \code{to} and \code{tr} plus four times the pooled
standard error}

\item{nGrid}{Number of grid points. Defaults to \code{1000}}

\item{plot}{Logical indicating whether posterior distribution should be
plotted. If \code{FALSE}, only data used for plotting are returned.
Defaults to \code{TRUE}}

\item{CI}{Logical indicating whether 95\% highest posterior credible interval
should be plotted. Defaults to \code{TRUE}}

\item{...}{Additional arguments passed to \code{matplot}}
}
\value{
Plots posterior distribution of the effect size, invisibly returns a
list with the data for the plot
}
\description{
Computes the posterior distribution of the effect size based on
the original and replication effect estimates and their standard errors,
assuming a common underlying effect size and an initial flat prior.
}
\examples{
## Example from Reproducibility Project Cancer Biology
## Aird: Data from https://elifesciences.org/articles/21253 Fig4B
hro <- 25.93
lhro <- log(hro)
hroCI <- c(5.48, 122.58)
se_lhro <- diff(log(hroCI))/(2*qnorm(0.975))
hrr <- 3.75
lhrr <- log(hrr)
hrrCI <- c(1.19, 11.81)
se_lhrr <- diff(log(hrrCI))/(2*qnorm(0.975))
repPosterior(to = lhro, so = se_lhro, tr = lhrr, sr = se_lhrr)

 
}
\author{
Samuel Pawel
}
