% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions-mpoint.R
\name{mpoint}
\alias{mpoint}
\alias{dmpoint}
\alias{rmpoint}
\alias{pmpoint}
\alias{qmpoint}
\title{Multivariate point mass distribution}
\usage{
dmpoint(x, location, log = FALSE)

rmpoint(n, location)

pmpoint(q, location, lower.tail = TRUE, log.p = FALSE)

qmpoint(p, location, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{vector or matrix of quantiles.}

\item{location}{vector of locations corresponding to the location of individual points.
Alternatively, a matrix with rows corresponding to the location of individual samples
and columns correspond to the location of individual points.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities
\code{p} are given as \code{log(p)}.}

\item{n}{number of observations.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities
are \eqn{P[X \le x]}, otherwise, \eqn{P[X \ge x]}.}

\item{p}{vector of probabilities.}
}
\value{
\code{dpoint} gives the density, \code{ppoint} gives the
distribution function, \code{qpoint} gives the quantile function,
and \code{rpoint} generates random deviates.
}
\description{
Density, distribution function,
quantile function and random generation for multivariate point distribution.
}
\examples{
# draw samples from a multivariate point distribution
rmpoint(10, location = c(0, 1))

}
