% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesTreePrior.R
\name{BayesTreePriorOrthogonal}
\alias{BayesTreePriorOrthogonal}
\title{Simulation of the tree prior in the case where we have one single variable (Case #3).}
\usage{
BayesTreePriorOrthogonal(alpha, beta, n_obs, n_iter = 500)
}
\arguments{
\item{alpha}{base parameter of the tree prior, \eqn{\alpha \in [0,1)}.}

\item{beta}{power parameter of the tree prior, \eqn{beta \geq 0}.}

\item{n_obs}{number of unique observations, \eqn{n_{obs}>1}.}

\item{n_iter}{number of trees to generate, \eqn{n_{iter}>0}.}
}
\value{
Returns a list containing, in the following order: the mean number of bottom nodes, the standard deviation of the number of bottom nodes, the mean of the depth, the standard deviation of the depth and a data.frame of vectors \eqn{(b_i,d_i)}, where \eqn{b_i} is the number of bottom nodes and \eqn{d_i} is the depth of the \eqn{i}th generated tree (\eqn{i=1, \ldots ,n_{iter}}).
}
\description{
Generate \eqn{n_{iter}} trees from the prior distribution in the case where we have one variable with a finite number of observations (Case #3).
}
\examples{
results1 = BayesTreePriorOrthogonal(.95,.5, 100)
results2 = BayesTreePriorOrthogonal(.95,.5, 250)
}
\seealso{
\code{\link{BayesTreePriorOrthogonalInf}}, \code{\link{BayesTreePriorNotOrthogonal}}
}

