% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{read_cpi}
\alias{read_cpi}
\title{Read CPI data from an Excel file}
\usage{
read_cpi(path_cpi)
}
\arguments{
\item{path_cpi}{Character path to the CPI Excel file.}
}
\value{
A \code{data.frame} with two columns:
\itemize{
  \item \code{Year} (\code{integer})
  \item \code{CPI}  (\code{numeric})
}
}
\description{
Loads and normalizes a CPI time series from an Excel worksheet. The function
detects the date/year column and the CPI/value column by pattern-matching on
lower-cased header names, parses localized numerics (via \code{to_num_commas()}),
collapses duplicate years by averaging, and returns a clean, sorted data frame.
}
\details{
\strong{Column detection.} Headers are lower-cased and matched with:
\itemize{
  \item Date/year: patterns \code{"date|fecha|year|anio|ano"}.
  \item CPI/value: patterns \code{"cpi|indice|price"}.
}
If either column cannot be identified, the function errors.

\strong{Cleaning.}
\itemize{
  \item Year is extracted as the first 4 digits of the date-like column.
  \item CPI is parsed with \code{to_num_commas()} (handles commas/thousands).
  \item \code{NA} rows are dropped; duplicates in \code{Year} are averaged.
  \item Output is sorted by \code{Year} ascending.
}
}
\examples{
\donttest{
# Create a temporary Excel file with sample CPI data
temp_file <- tempfile(fileext = ".xlsx")
df_sample <- data.frame(
  Fecha = c("2019-01-01", "2020-01-01", "2021-01-01", "2022-01-01"),
  Indice = c(95.5, 100.0, 103.2, 108.7)
)
openxlsx::write.xlsx(df_sample, temp_file)

# Read the CPI data
df <- read_cpi(temp_file)
print(df)

# Verify structure
stopifnot(
  is.data.frame(df),
  all(c("Year", "CPI") \%in\% names(df)),
  nrow(df) == 4
)

# Clean up
unlink(temp_file)
}

}
\seealso{
\code{\link{read_weights_matrix}}, \code{\link{bayesian_disaggregate}}
}
