/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.util.Date;
import dr.evolution.util.TimeScale;
import dr.evolution.util.Units;
import dr.evoxml.util.XMLUnits;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class SimpleTreeParser
extends AbstractXMLObjectParser {
    public static final String SIMPLE_TREE = "tree";
    public static final String USING_DATES = "usingDates";
    public static final String DATE = "date";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{XMLUnits.SYNTAX_RULES[0], new ElementRule(SimpleNode.class)};

    @Override
    public String getParserName() {
        return SIMPLE_TREE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
        boolean bl = xMLObject.getAttribute(USING_DATES, false);
        SimpleNode simpleNode = (SimpleNode)xMLObject.getChild(SimpleNode.class);
        if (simpleNode == null) {
            throw new XMLParseException("node element missing from tree");
        }
        SimpleTree simpleTree = new SimpleTree(simpleNode);
        if (bl) {
            double d;
            Date date;
            int n;
            Date date2;
            int n2;
            TimeScale timeScale = null;
            for (n2 = 0; n2 < simpleTree.getTaxonCount(); ++n2) {
                date2 = (Date)simpleTree.getTaxonAttribute(n2, DATE);
                if (date2 == null) {
                    date2 = (Date)simpleTree.getNodeAttribute(simpleTree.getExternalNode(n2), DATE);
                }
                if (date2 == null || timeScale != null && !date2.after((Date)timeScale)) continue;
                timeScale = date2;
            }
            for (n2 = 0; n2 < simpleTree.getInternalNodeCount(); ++n2) {
                date2 = (Date)simpleTree.getNodeAttribute(simpleTree.getInternalNode(n2), DATE);
                if (date2 == null || timeScale != null && !date2.after((Date)timeScale)) continue;
                timeScale = date2;
            }
            if (timeScale == null) {
                throw new XMLParseException("no date elements in tree (and usingDates attribute set)");
            }
            TimeScale timeScale2 = new TimeScale(timeScale.getUnits(), true, ((Date)timeScale).getAbsoluteTimeValue());
            for (n = 0; n < simpleTree.getTaxonCount(); ++n) {
                date = (Date)simpleTree.getTaxonAttribute(n, DATE);
                if (date == null) {
                    date = (Date)simpleTree.getNodeAttribute(simpleTree.getExternalNode(n), DATE);
                }
                if (date == null) continue;
                d = timeScale2.convertTime(date.getTimeValue(), date);
                simpleTree.setNodeHeight(simpleTree.getExternalNode(n), d);
            }
            for (n = 0; n < simpleTree.getInternalNodeCount(); ++n) {
                date = (Date)simpleTree.getNodeAttribute(simpleTree.getInternalNode(n), DATE);
                if (date == null) continue;
                d = timeScale2.convertTime(date.getTimeValue(), date);
                simpleTree.setNodeHeight(simpleTree.getInternalNode(n), d);
            }
            MutableTree.Utils.correctHeightsForTips(simpleTree);
        }
        simpleTree.setUnits(type);
        return simpleTree;
    }

    @Override
    public String getParserDescription() {
        return "This element represents a rooted binary tree and associated attributes.";
    }

    @Override
    public Class getReturnType() {
        return Tree.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

