% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowfunction.R
\name{ColNoiseBC}
\alias{ColNoiseBC}
\title{Barplots of Column Noise for Biclusters}
\usage{
ColNoiseBC(result, matrix, BC = 1:result@Number, plot.type = "device",
  filename = "ColNoise")
}
\arguments{
\item{result}{A Biclust Object.}

\item{matrix}{Accompanying binary data matrix which was used to obtain \code{result}.}

\item{BC}{Numeric vector to select of which BC's a column noise bar plot should be drawn.}

\item{plot.type}{Output Type
\itemize{
\item \code{"device"}: All plots are outputted to new R graphics devices (default).
\item \code{"file"}: All plots are saved in external files. Plots are joint together in a single \code{.pdf} file.
\item \code{"other"}: All plots are outputted to the current graphics device, but will overwrite each other. Use this if you want to include one or more plots in a sweave/knitr file or if you want to export a single plot by your own chosen format.
}}

\item{filename}{Base filename (with/without directory) for the plots if \code{plot.type="file"} (default=\code{"RowCoverage"}).}
}
\description{
Draws barplots of column noise of chosen biclusters. This plot can be helpful in determining which column label is often zero in noisy biclusters.
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
data <- data[sample(1:nrow(data),nrow(data)),sample(1:ncol(data),ncol(data))]
result <- bibit2(data,minr=5,minc=5,noise=1)
ColNoiseBC(result=result,matrix=data,BC=1:3)
}
}
\author{
Ewoud De Troyer
}

