% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_dens_cont.R
\name{auto_dens_cont}
\alias{auto_dens_cont}
\title{auto_dens_cont}
\usage{
auto_dens_cont(
  data,
  s_mean = TRUE,
  s_median = TRUE,
  mean_line_args = list(),
  median_line_args = list(),
  densplot_args = list(),
  theme_func = theme_serene,
  lang_labs = c("EN", "SPA")
)
}
\arguments{
\item{data}{Name of the dataframe}

\item{s_mean}{Show mean. Logical operator to indicate if the mean should be plotted. Default is TRUE}

\item{s_median}{Show median. Logical operator to indicate if the median should be plotted. Default is TRUE}

\item{mean_line_args}{Arguments to be passed to \code{geom_vline()} of plotted median line when \code{s_mean = TRUE}. Default arguments are:
\itemize{
\item color = "red"
\item linetype="solid"
\item linewidth = 1
}}

\item{median_line_args}{Arguments to be passed to \code{geom_vline()} of plotted median line when \code{s_median = TRUE}. Default arguments are:
\itemize{
\item color = "blue"
\item linetype = "dotdash"
\item linewidth = 1
}}

\item{densplot_args}{List of arguments to be passed to "geom_density"}

\item{theme_func}{Theme to display plots. Default is "theme_serene"}

\item{lang_labs}{Language of the resulting plots. Can be "EN" for english or "SPA" for spanish. Default is "SPA"}
}
\value{
Returns a list containing the generated density plots
}
\description{
#' Automatically generates density plots of continuous variables from a database. The names of the variables are set to the names defined in the database. As a result, graphs generated with the default theme "theme_serene" will be obtained. In this function, the user must define each variable label with "label" function from "table1" package.
}
\examples{
data <- data.frame(group = rep(letters[1:2], 30),
var1 = rnorm(30, mean = 15, sd = 5),
var2 = rnorm(30, mean = 20, sd = 2),
var3 = rnorm(30, mean = 10, sd = 1),
var4 = rnorm(30, mean = 5, sd =2))

data$group<-as.factor(data$group)

densityplots <- auto_dens_cont(data = data)

densityplots

densityplots$var1


}
\author{
JMCR
}
