% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_multg.R
\name{continuous_multg}
\alias{continuous_multg}
\title{Bivariate analysis for more than 2 groups}
\usage{
continuous_multg(data, groupvar, flextableformat = TRUE)
}
\arguments{
\item{data}{Data frame from which variables will be extracted.}

\item{groupvar}{Grouping variable. Must have exactly 2 levels.}

\item{flextableformat}{Logical operator to indicate the output desired. Default is TRUE. When FALSE, function will return a dataframe format.}
}
\value{
A dataframe or flextable containing pvalues for each test along with the normality and homocedasticity tests p values. An extra column will be shown indicating the recommended significant test
}
\description{
Generates a HTML table of bivariate analysis for 2 groups.
}
\examples{
data <- iris

data$Species<-as.factor(data$Species)

continuous_multg(data = data, groupvar = "Species", flextableformat = FALSE)

}
