% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteBinaryDosage.R
\name{getrsq}
\alias{getrsq}
\title{Calculate imputation r squared}
\usage{
getrsq(dosage, p0, p1, p2)
}
\arguments{
\item{dosage}{Dosage values}

\item{p0}{Pr(g=0) - unused}

\item{p1}{Pr(g=1) - unused}

\item{p2}{Pr(g=2)}
}
\value{
Imputation r squared
}
\description{
Routine to calculate the imputation r squared given the dosages
and Pr(g=2).
This is an estimate for the imputation r squared returned from
minimac and impute2. The r squared values are calculated slightly
differently between the programs. This estimate is based on the
method used by minimac. It does well for minor allele frequencies
above 5\%. This function is used internally and is exported for
use in examples.
}
\examples{
# Get information about binary dosage file
bdfile <- system.file("extdata", "vcf1a.bdose", package = "BinaryDosage")
bdinfo <- getbdinfo(bdfiles = bdfile)
snp1 <- getsnp(bdinfo = bdinfo, 1, dosageonly = FALSE)
rsq <- BinaryDosage:::getrsq(snp1$dosage, p2 = snp1$p2)
}
