% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{color_mapping}
\alias{color_mapping}
\title{maps numeric values to a color}
\usage{
color_mapping(x, maxi, mini, color_sel)
}
\arguments{
\item{x}{Vector.}

\item{maxi}{Numeric. Maximum value. Defaults to maximum value in vector.
Can be useful to set this manually if there are outliers in the scan data}

\item{mini}{Numeric. Minimum value. Defaults to minimum value in vector.
Can be useful to set this manually if there are outliers in the scan data}

\item{color_sel}{Vector. Colors to use for map. Defaults to a scale of
"grey", "blue", "green", "yellow", "orange", "red", "pink".}
}
\value{
Vector of hex color values same length as x
}
\description{
maps numeric values to a color
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  nifti <- import_scan(scan_filepath)
  url2 <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url2, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  mat_peak <- voxel_point_intersect(surface_mesh, nifti, ct_eqn = "linear",
                                    ct_params = c(68.4, 1.106),)
  colors <- color_mapping(mat_peak)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
