% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableImportance.boot.R
\name{hist.BranchGLMVI.boot}
\alias{hist.BranchGLMVI.boot}
\title{Histogram Method for BranchGLMVI.boot Objects}
\usage{
\method{hist}{BranchGLMVI.boot}(
  x,
  which = "all",
  linecol = "red",
  linelwd = 2,
  xlim = NULL,
  xlab = "Modified Variable Importance",
  main = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{BranchGLMVI.boot} object.}

\item{which}{which approximate null distributions to plot, can use a numeric vector of
indices, a character vector of names, or "all" for all variables. The default
is to create histograms for each set of variables that are not kept in each model.}

\item{linecol}{the color of the line which indicates the observed modified variable
importance values.}

\item{linelwd}{the width of the line which indicates the observed modified variable
importance values.}

\item{xlim}{a numeric vector of length 2, giving the x coordinates range.}

\item{xlab}{a label for the x axis.}

\item{main}{a main title for the plot.}

\item{...}{further arguments passed to \link{hist.default}.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
Creates histograms of approximate null distributions for
the modified variable importance values.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
showprogress = FALSE)

# Getting approximate null distributions
set.seed(40174)
myBoot <- VariableImportance.boot(VS, showprogress = FALSE)

# Plotting histograms of second set of variables
hist(myBoot, which = 2)

# Plotting histograms of third set of variables
hist(myBoot, which = 3, linecol = "blue", linelwd = 5)

}
\seealso{
\link{boxplot.BranchGLMVI.boot}
}
