% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{Heatmap_Cor}
\alias{Heatmap_Cor}
\title{plot the heatmap of marker genes across different species}
\usage{
Heatmap_Cor(
  RNA1,
  RowType1 = "",
  ColType1 = "",
  cluster_cols = TRUE,
  cluster_rows = FALSE,
  Color1 = NULL,
  ...
)
}
\arguments{
\item{RNA1}{correlation of expression in each cell type}

\item{RowType1}{character, indicating the cell types that you want to show
on the row in heatmap. RowType1='' means show all cell types}

\item{ColType1}{character, indicating the cell types that you want to show
on the column in heatmap. RowType1='' means show all cell types}

\item{cluster_cols}{boolean values determining if columns should be clustered
or hclust object}

\item{cluster_rows}{boolean values determining if rows should be clustered or

hclust object}

\item{Color1}{vector of colors used in heatmap}

\item{...}{parameter in pheatmap}
}
\value{
pheatmap object
}
\description{
plot the heatmap of marker genes across different species
}
\examples{
load(system.file("extdata", "network_example.rda", package = "CACIMAR"))
n1 <- Identify_ConservedNetworks(OrthG_Mm_Zf,mmNetwork,zfNetwork,'mm','zf')
Heatmap_Cor(n1[[2]],cluster_cols=TRUE, cluster_rows=FALSE)
}
