% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-species_markers.R
\name{Identify_ConservedMarkers}
\alias{Identify_ConservedMarkers}
\title{Identify orthologs marker genes for two species}
\usage{
Identify_ConservedMarkers(
  OrthG,
  Species1_Marker_table,
  Species2_Marker_table,
  Species_name1,
  Species_name2,
  match_cell_name = NULL
)
}
\arguments{
\item{OrthG}{ortholog genes database}

\item{Species1_Marker_table}{data.frame of species 1, first column should be gene name,
second column should be Clusters corresponding to marker gene}

\item{Species2_Marker_table}{data.frame of species 2, first column should be gene name,
second column should be Clusters corresponding to marker gene
of marker genes.}

\item{Species_name1}{character, indicating the species names of Species1_Marker_table.}

\item{Species_name2}{character, indicating the species names of Species2_Marker_table}

\item{match_cell_name}{characters contained in both cell names
to match similar cell types}
}
\value{
Data frame of conserved markers
}
\description{
Identify orthologs marker genes for two species based on orthologs database
}
\examples{
load(system.file("extdata", "CellMarkers.rda", package = "CACIMAR"))
o1 <- Identify_ConservedMarkers(OrthG_Mm_Zf,Mm_marker_cell_type,
Zf_marker_cell_type,Species_name1 = 'mm',Species_name2 = 'zf')
o2 <- Identify_ConservedMarkers(OrthG_Zf_Ch,Ch_marker_cell_type,
Zf_marker_cell_type,Species_name1 = 'ch',Species_name2 = 'zf')
}
