% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Customer.R
\name{Customer}
\alias{Customer}
\title{R6 Class representing a customer.  Otherwise known as the CADF.}
\description{
A short description...
}
\details{
Call Customer$new() to convert transactional data to CADF format
}
\examples{
library(CADF)
data("transactions")
customer <- subset(transactions, transactions$ID == 40)
today.study.cutoff <- max(customer$PURCHASE_DATE)
customer.40.CADF <- Customer$new(customer, today.study.cutoff)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{output}}{Stores all information 
in R format at the customer level.}

\item{\code{payload}}{Stores all computed customer information 
in JSON format for integration into other systems.  
This is not quite an API but designed 
so that customer information can be imported to other 
formats and systems.}

\item{\code{data}}{a data frame that stores purchase 
information for a single customer.  Input data 
for various calculations in initialize (df_customer)}

\item{\code{id}}{The customer id.  This will be the same ID 
as provided in the input transaction file.}

\item{\code{study_name}}{A name to associate with the cohort study.
#The name can be whatever is easiest to associate with the set 
of customer id and dates included in
the analysis.}

\item{\code{study_begin_date}}{Begin date of the customer study. 
In theory this should be min(TRANSACTION_DATE) 
for each customer in the dataset.}

\item{\code{timing}}{Monthly timing computes T as months. 
Most commonly utilized and is the default.}

\item{\code{transaction_dates}}{All transaction dates for the customer}

\item{\code{transaction_months}}{All YYYY_MM transaction dates
for the customer}

\item{\code{first_purchase_date}}{First purchase date for the customer.}

\item{\code{last_purchase_date}}{Last purchase date for the customer.
#' @field repeat_customer repeat_customer
 if the following conditions
are true.  The customer has more 
than one transaction.  The second transaction
date is greater than the first transaction date.}

\item{\code{repeat_customer_by_day}}{description}

\item{\code{today}}{today
#' @field  T a measure of time between first
 date of activity and purchase.}

\item{\code{T_ss}}{T_ss}

\item{\code{transaction_range_complete}}{shows a 
consecutive sequence usually beginning at 1}

\item{\code{purchase_count}}{purchase count}

\item{\code{purchase_string}}{description}

\item{\code{purchase_string_as_matrix}}{purchase string as matrix}

\item{\code{recency_string_as_matrix}}{recency string as matrix}

\item{\code{Freq}}{frequency count}

\item{\code{logistic_modeling_matrix}}{Stores customer's 
logistic modeling matrix.  (One row for each time period 
(T), 1 = purchase; 0 = no purchase)}

\item{\code{logistic_modeling_matrix_ss}}{logistic_modeling_matrix_ss}

\item{\code{logistic_modeling_matrix_custom}}{logistic_modeling_matrix_custom}

\item{\code{survival_modeling_matrix}}{Stores customer's 
modeling matrix for survival analysis.  For survival analysis '1' 
means that the customer has stopped being a customer.  
'0' means that the customer is continuing to be a customer.}

\item{\code{survival_modeling_matrix_ss}}{survival_modeling_matrix_ss}

\item{\code{survival_modeling_matrix_custom}}{survival_modeling_matrix_custom}

\item{\code{repeat_customer}}{This can be used to filter out 
repeat customers from analysis.  Repeat customer 
based on YYYY_MM.  (Customer with only two purchases
 in January would not be a repeat customer)
however it's by day instead of YYYY_MM.
PURCHASE STRINGS
purchase_string Utilizes the 'create.purchase.string' 
function to create a purchase string.  "1" if 
purchase was made during the
purchase period; "0" otherwise.  
No special rules are applied and the purchase string 
reflects true purchase history.
df_customer:  data frame for single customer, id column,
 purchase date column}

\item{\code{T}}{T is a cancellation time.  CADF offers 
different ways to estimate the cancellation time
strict_quitter:  Customer leaves after first period 
of inactivity.  Example purchase string 11001.  T=3
strict_stayer:   T is the last period of transaction in 
the purchase string. 11001.  T=5
As T becomes longer strict_quitter will have a tendancy 
to underestimate retention.  Strict_stayer will have a
 tendancey to overestimate
If you know your customers come and go at free
 will you can utilize a Migration model or choose 
 T between strict quitter and strict stayer

T_ss T_ss}

\item{\code{T_custom}}{T_custom
logistic_modeling_matrix  Stores rows for 
the customer that contribute to a logistic 
modeling matrix.
Assumes strict/perm cancellations.  
Customer relationship starts at time 1 and 
ends at time N (with perm cancellation and no pauses in between)
This is usually known as a contractual relationship 
logistic_modeling_matrix_sc Assumes strict stayer assumption
$field logistic_modeling_matrix_custom
survival_modeling_matrix  Stores rows for 
the customer that contribute to a survival 
modeling matrix.
$field logistic_modeling_matrix_custom
cleanup and data storage
empty working df_customer data frame 
and place the result in the class, name it 'data'}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Customer-new}{\code{Customer$new()}}
\item \href{#method-Customer-clone}{\code{Customer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Customer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Customer-new}{}}}
\subsection{Method \code{new()}}{
Creates a CADF profile for a given customer
based on the input transactional data
usually an R list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Customer$new(df_customer = NA, today = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df_customer}}{description}

\item{\code{today}}{}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Customer` object.  Converted transactional data to CADF format.
To access cadf[[1]], etc...
Represents customer data (for a particular id) in the "CADF" format
df_customer$Tdays df_customer data frame column:
to compute "days from first purchase"
df_customer$month_yr date converted to YYYY_MM format
df_customer$Tmonths Number of months between purchase date 
and first purchase date.  Rounded up to nearest month
id the customerid which identifies the customer
in the CADF class.  
transaction_dates All unique transaction 
dates for customer
All unique YYYY_MM combinations 
for customer transactions.  This is used for building purchase strings.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Customer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Customer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Customer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
