% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calf_wrappers.R
\name{calf_fractional}
\alias{calf_fractional}
\title{calf_fractional}
\usage{
calf_fractional(
  data,
  nMarkers,
  controlProportion = 0.8,
  caseProportion = 0.8,
  optimize = "pval",
  verbose = FALSE
)
}
\arguments{
\item{data}{Matrix or data frame. Must be binary data such that the first column must contain case/control dummy coded variable, as function is only approprite for binary data.}

\item{nMarkers}{Maximum number of markers to include in creation of sum.}

\item{controlProportion}{Proportion of control samples to use, default is .8.}

\item{caseProportion}{Proportion of case samples to use, default is .8.}

\item{optimize}{Criteria to optimize, "pval" or "auc".  Defaults to "pval".}

\item{verbose}{Logical. Indicate TRUE to print activity at each iteration to console. Defaults to FALSE.}
}
\value{
A data frame containing the chosen markers and their assigned weight (-1 or 1)

The optimal AUC or pval for the classification.

rocPlot. A plot object from ggplot2 for the receiver operating curve.
}
\description{
Randomly selects from binary input provided to data parameter while ensuring the requested proportions of case and control variables are used and runs Coarse Approximation Linear Function.
}
\examples{
calf_fractional(data = CaseControl, nMarkers = 6, controlProportion = .8, caseProportion = .4)
}
