% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess-and-validate-data.R
\name{dataset_has_mandatory_columns}
\alias{dataset_has_mandatory_columns}
\title{Check if the dataset has all mandatory columns}
\usage{
dataset_has_mandatory_columns(dataset)
}
\arguments{
\item{dataset}{A data frame representing the dataset to be validated.}
}
\value{
A logical value indicating whether all the mandatory columns are present in the dataset.
}
\description{
This function checks if a given dataset contains all the mandatory columns specified in the \code{mandatory_columns} vector.
}
\examples{
# Sample dataset
sample_data <- data.frame(
                Project = c("Project A", "Project A", "Project B"),
                Date = c("2023-07-31", "2023-08-01", "2023-08-02"),
                Site = c("Site X", "Site Y", "Site Z"),
                Country = c("Country A", "Country B", "Country C"),
                Latitude = c(34.05, 36.16, 40.71),
                Longitude = c(-118.24, -115.15, -74.01),
                Species = c("Species 1", "Species 2", "Species 3"),
                Genotype = c("Genotype A", "Genotype B", "Genotype C"),
                Condition = c("Condition 1", "Condition 2", "Condition 3"),
                Timepoint = c("Timepoint 1", "Timepoint 1", "Timepoint 2"),
                Temperature = c(30.2, 31.5, 29.8),
                Pam_value = c(0.5, 0.6, 0.8)
                )

dataset_has_mandatory_columns(sample_data)
# Output: TRUE

# Sample dataset with missing columns
missing_columns_data <- data.frame(Label = c("A", "B", "C"),
                                   Date = c("2023-07-31", "2023-08-01", "2023-08-02"))

dataset_has_mandatory_columns(missing_columns_data)
# Output: FALSE
}
