% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess-and-validate-data.R
\name{validate_cbass_dataset}
\alias{validate_cbass_dataset}
\title{Validate CBASS Dataset}
\usage{
validate_cbass_dataset(dataset)
}
\arguments{
\item{dataset}{A data frame representing the CBASS dataset to be processed and validated.}
}
\value{
A processed and validated CBASS dataset with appropriate data types for its columns.
}
\description{
This function validates a dataset to ensure it contains all the mandatory columns required for further processing.
If any mandatory columns are missing, it raises an error with the list of missing columns.
}
\examples{
# Assuming a dataset named 'cbass_dataset' is available in the environment
data(cbass_dataset)
preprocessed_data <- preprocess_dataset(cbass_dataset)
validate_cbass_dataset(preprocessed_data)

}
\seealso{
\code{\link{dataset_has_mandatory_columns}}, \code{\link{convert_columns}}, \code{\link{check_enough_unique_temperatures_values}}
}
