% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBRT.R
\name{getDataGroup}
\alias{getDataGroup}
\title{Downloading data groups}
\usage{
getDataGroup(
  group,
  CBRTKey = myCBRTKey,
  freq,
  startDate = "01-01-1950",
  endDate,
  na.rm = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{group}{Code for the data group.}

\item{CBRTKey}{Your personal CBRT access key.}

\item{freq}{Numeric, the frequency of the data series. If not defined, the default
(the highest possible frequency) will be used. The frequencies are as follows:
\describe{
  \item{1}{Day}
  \item{2}{Work day}
  \item{3}{Week}
  \item{4}{Biweekly}
  \item{5}{Month}
  \item{6}{Quarter}
  \item{7}{Six months}
  \item{8}{Year}
}
If a frequency level lower than the default is used, the data will be aggregated
by using the default method for that data group (for example, if monthly data
are download for weekly series).}

\item{startDate}{The beginning date for data series (DD-MM-YYYY).}

\item{endDate}{The ending date for data series (DD-MM-YYYY). If not defined, the default
(the latest available) will be used.}

\item{na.rm}{Logical variable to drop all missing dates.}

\item{verbose}{TRUE turns on status and information messages to the console.}
}
\value{
a data.table object
}
\description{
Downloads all data series of a data group
}
\examples{
\dontrun{
myData <- getDataGroup("bie_dbafod")
}

}
