% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doWlm.R
\name{doWlm}
\alias{doWlm}
\title{Perform Weighted Linear Regression}
\usage{
doWlm(DF, weights = NULL)
}
\arguments{
\item{DF}{data frame, it must contain a column named 'Concentration' and a column named 'Response'}

\item{weights}{the weights used in linear regression, default is NULL. User can easily define weights, e.g., "1/x", "1/x^2", "1/y"}
}
\value{
list, weighted linear regression result
}
\description{
Perform weighted linear regression and evaluate by using summed residual.
}
\examples{
Concentration <- rep(c(10, 50, 100, 500), each = 3)
Response <- c(133, 156, 177, 1300, 1450, 1600, 4000, 3881, 3700, 140000, 139000, 140000)
DF <- cbind.data.frame(Concentration = Concentration, Response = Response)
result <- doWlm(DF, weights = "1/x^2")
}
\author{
Yonghui Dong
}
