% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEDA.R
\name{permuteLimma}
\alias{permuteLimma}
\title{Modeling CRISPR data with a permutation test between conditions 
by R package limma}
\usage{
permuteLimma(data, design, contrast.matrix, nperm)
}
\arguments{
\item{data}{A numeric matrix containing log2 expression level of sgRNAs
with rows corresponding to sgRNAs and columns to samples.}

\item{design}{A design matrix with rows corresponding to samples and
columns to coefficients to be estimated.}

\item{contrast.matrix}{A matrix with columns corresponding to contrasts.}

\item{nperm}{Number of permutations}
}
\value{
A numeric matrix containing log2 fold changes with permutations
}
\description{
The lmFit function in R package limma is employed for group comparisons
under permutations.
}
\examples{
y <- matrix(rnorm(1000*6),1000,6)
condition <- gl(2,3,labels=c("Control","Baseline"))
design <- model.matrix(~ 0 + condition)
contrast.matrix <- makeContrasts("conditionControl-conditionBaseline",levels=design)
fit <- permuteLimma(y,design,contrast.matrix,20)

}
