% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_to_map.R
\name{string_to_map}
\alias{string_to_map}
\title{Converts a comma-separated string to a CHOIR BM}
\usage{
string_to_map(map_str = "", delim = ",")
}
\arguments{
\item{map_str}{The delimited CBM string.}

\item{delim}{The delimiter for the CBM string.}
}
\value{
ret_df data.frame with all of the CHOIR BM segment IDs with a 1
if the segment was present and 0 otherwise.
}
\description{
Takes a string of IDs that are separated by a comma and converts the
information into a data frame with a binary indication of whether or not
an ID appeared. Useful for plotting an individual's CHOIR BM or for
isolating particular sections to highlight.
}
\examples{
cbm_str <- "101,102,103,104,201,202"
cbm_df <- string_to_map(cbm_str)
#plot in a male or female bodymap...
plot_male_choirbm(cbm_df, "value")

}
